/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkWork;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWTrackerStatus;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class VWWorkItemTableModel
extends AbstractTableModel
implements IVWPropertyChangeListener {
    private static final boolean DISPLAY_REMINDER_OVERDUE = false;
    public static final int WORKITEM_TABLE_MAP_COL = 0;
    public static final int WORKITEM_TABLE_STEP_COL = 1;
    public static final int WORKITEM_TABLE_OCCURRENCE_COL = 2;
    public static final int WORKITEM_TABLE_PARTICIPANT_COL = 3;
    public static final int WORKITEM_TABLE_RECEIVED_COL = 4;
    public static final int WORKITEM_TABLE_STATUS_COL = 5;
    public static final int WORKITEM_TABLE_RESPONSE_COL = 6;
    public static final int WORKITEM_TABLE_COMMENTS_COL = 7;
    protected VWTrkDataModel m_trackerDataModel = null;
    protected Vector m_workItems = null;
    private Vector m_columnNames = new Vector();
    private int m_rowCount = -1;
    VWTableSorter m_sorter = null;

    public VWWorkItemTableModel(VWTrkDataModel trackerDataModel) {
        this.createTableSorter();
        this.m_trackerDataModel = trackerDataModel;
        this.initColumnNames();
        this.initData();
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
    }

    VWTrkDataModel getDataModel() {
        return this.m_trackerDataModel;
    }

    private void createTableSorter() {
        this.m_sorter = new VWTableSorter(this){

            public void tableChanged(TableModelEvent e) {
                int col = e.getColumn();
                if (e.getType() == 0 && col != 4 && col != -1) {
                    this.fireTableChanged(e);
                } else {
                    super.tableChanged(e);
                    this.sortByColumn(4);
                }
            }
        };
    }

    void initData() {
        if (this.m_workItems == null) {
            this.m_workItems = new Vector();
        } else {
            this.m_workItems.removeAllElements();
        }
        Vector steps = this.m_trackerDataModel.getStepCollection();
        for (int i = 0; i < steps.size(); ++i) {
            Vector occurrences;
            VWTrkStep step;
            Object obj = steps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkStep) || !(step = (VWTrkStep)obj).isActive() || (occurrences = step.getActiveOccurrences()) == null || occurrences.size() <= 0) continue;
            for (int j = 0; j < occurrences.size(); ++j) {
                Vector participants;
                VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)occurrences.elementAt(j);
                if (occurrence == null || (participants = occurrence.getActiveParticipants()) == null) continue;
                this.m_workItems.addAll(participants);
            }
        }
        this.fireTableDataChanged();
    }

    public Object getValueAt(int row, int col) {
        if (this.m_workItems == null) {
            return null;
        }
        if (row < 0 || row >= this.m_workItems.size()) {
            return null;
        }
        ImageIcon icon = null;
        Object obj = this.m_workItems.elementAt(row);
        if (obj != null && obj instanceof VWTrkParticipant) {
            VWTrkParticipant participant = (VWTrkParticipant)obj;
            VWTrkStep step = participant.getStep();
            switch (col) {
                case 0: {
                    VWTrkMap map;
                    if (step != null && this.m_trackerDataModel != null && (map = this.m_trackerDataModel.getMap(step.getMapId())) != null) {
                        return map.getMapName();
                    }
                    return null;
                }
                case 1: {
                    if (step != null) {
                        return step.getStepName();
                    }
                    return null;
                }
                case 2: {
                    VWTrkWork work = participant.getWork();
                    if (work != null && work.getStepOccurrence() != null) {
                        return new Integer(work.getStepOccurrence().getOccurrenceIndex() + 1);
                    }
                    return null;
                }
                case 3: {
                    if (participant != null) {
                        icon = participant.getLockedStatusIcon();
                    }
                    String name = this.getParticipantName(participant);
                    return new JLabel(name, icon, 2);
                }
                case 4: {
                    if (participant != null) {
                        return participant.getDateReceived();
                    }
                    return null;
                }
                case 5: {
                    if (participant != null) {
                        return new VWTrackerStatus(participant.getStatus(), participant.getCompletionDate());
                    }
                    return null;
                }
                case 6: {
                    if (participant != null) {
                        try {
                            return participant.getResponse();
                        }
                        catch (VWException ex) {
                            // empty catch block
                        }
                    }
                    return null;
                }
                case 7: {
                    if (participant != null) {
                        try {
                            return participant.getComments();
                        }
                        catch (VWException ex) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    protected VWTrkParticipant getParticipantAt(int row) {
        if (this.m_workItems == null) {
            return null;
        }
        if (row < 0 || row >= this.m_workItems.size()) {
            return null;
        }
        Object icon = null;
        Object obj = this.m_workItems.elementAt(row);
        if (obj != null && obj instanceof VWTrkParticipant) {
            VWTrkParticipant participant = (VWTrkParticipant)obj;
            return participant;
        }
        return null;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement(VWResource.s_map);
        this.m_columnNames.addElement(VWResource.s_step);
        this.m_columnNames.addElement("");
        this.m_columnNames.addElement(VWResource.s_participant);
        this.m_columnNames.addElement(VWResource.s_received);
        this.m_columnNames.addElement(VWResource.s_status);
        this.m_columnNames.addElement(VWResource.s_response);
        this.m_columnNames.addElement(VWResource.s_comments);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 4: {
                return Date.class;
            }
            case 2: {
                return Integer.class;
            }
            case 5: {
                return VWTrackerStatus.class;
            }
            case 0: 
            case 1: 
            case 3: {
                return JLabel.class;
            }
            case 6: 
            case 7: {
                return String.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public int getRowCount() {
        if (this.m_workItems != null) {
            return this.m_workItems.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        if (event == null || this.m_workItems == null || this.m_workItems.size() == 0) {
            return;
        }
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            if (source == null) {
                return;
            }
            Vector items = null;
            int type = event.getID();
            switch (type) {
                case 701: {
                    items = source.getItemsChanged();
                    if (items == null || items.size() == 0) {
                        return;
                    }
                    Object participant = null;
                    int mapId = -1;
                    int stepId = -1;
                    String wobNum = null;
                    int col = 3;
                    for (int i = 0; i < items.size(); ++i) {
                        VWTrkStep step;
                        boolean row = false;
                        obj = items.elementAt(i);
                        if (!(obj instanceof VWTrkStep) || (step = (VWTrkStep)obj) == null) continue;
                        mapId = step.getMapId();
                        stepId = step.getStepId();
                        Vector activeOccurrences = step.getActiveOccurrences();
                        if (activeOccurrences == null || activeOccurrences.size() == 0) continue;
                        for (int j = 0; j < activeOccurrences.size(); ++j) {
                            Vector workCollection;
                            obj = activeOccurrences.elementAt(j);
                            if (obj == null || !(obj instanceof VWTrkStepOccurrence) || (workCollection = ((VWTrkStepOccurrence)obj).getWorkCollection()) == null) continue;
                            for (int k = 0; k < workCollection.size(); ++k) {
                                obj = workCollection.elementAt(k);
                                if (obj == null || !(obj instanceof VWTrkWork)) continue;
                                VWTrkWork work = (VWTrkWork)obj;
                                wobNum = work.getWorkObjectNumber();
                                for (j = 0; j < this.m_workItems.size(); ++j) {
                                    String aWobNum;
                                    VWTrkParticipant aParticipant;
                                    if (!(this.m_workItems.elementAt(j) instanceof VWTrkParticipant) || mapId != (step = (aParticipant = (VWTrkParticipant)this.m_workItems.elementAt(j)).getStep()).getMapId() || stepId != step.getStepId() || aParticipant.getWork() == null || VWStringUtils.compareIgnoreCase(wobNum, aWobNum = aParticipant.getWork().getWorkObjectNumber()) != 0) continue;
                                    this.fireTableCellUpdated(j, j);
                                }
                            }
                        }
                    }
                    break;
                }
                case 704: 
                case 705: {
                    this.initData();
                }
            }
        }
    }

    boolean isLockable(int row) {
        return this.isLockedStatus(row, 1);
    }

    boolean isUnockable(int row) {
        return this.isLockedStatus(row, 2);
    }

    boolean isLockedStatus(int row, int lockedStatus) {
        if (this.m_workItems == null || row < 0 || row >= this.m_workItems.size()) {
            return false;
        }
        Object obj = this.m_workItems.elementAt(row);
        return obj != null && obj instanceof VWTrkParticipant && ((VWTrkParticipant)obj).getLockedStatus() == lockedStatus;
    }

    VWTrkParticipant getItem(int row) {
        Object obj;
        if (this.m_workItems != null && row >= 0 && row < this.m_workItems.size() && (obj = this.m_workItems.elementAt(row)) != null && obj instanceof VWTrkParticipant) {
            return (VWTrkParticipant)obj;
        }
        return null;
    }

    VWTrkStep getStep(int row) {
        VWTrkParticipant workItem = this.getItem(row);
        if (workItem != null) {
            return workItem.getStep();
        }
        return null;
    }

    VWTrkStepOccurrence getStepOccurrence(int row) {
        VWTrkParticipant workItem = this.getItem(row);
        if (workItem != null) {
            return workItem.getStepOccurrence();
        }
        return null;
    }

    VWTrkMap getMap(int row) {
        VWTrkStep step = this.getStep(row);
        if (step != null && this.m_trackerDataModel != null) {
            return this.m_trackerDataModel.getMap(step.getMapId());
        }
        return null;
    }

    public VWTableSorter getTableSorter() {
        return this.m_sorter;
    }

    String getParticipantName(VWTrkParticipant participant) {
        VWParticipant vwParticipant;
        VWParticipantItem pItem = new VWParticipantItem(participant.getParticipant());
        String name = pItem.getDisplayName();
        String queueName = null;
        if (name == null) {
            queueName = participant.getQueueName();
        }
        if ((vwParticipant = participant.getLockedUser()) != null && vwParticipant.getParticipantName() != null && vwParticipant.getParticipantName().length() > 0) {
            VWParticipantItem pUser = new VWParticipantItem(vwParticipant);
            if (name != null) {
                if (VWStringUtils.compare(pItem.getShortName(), pUser.getShortName()) != 0) {
                    name = name + "(" + pUser.getDisplayName() + ")";
                }
            } else {
                name = queueName != null ? "[" + queueName + "]" + " " + pUser.getDisplayName() : "";
            }
        } else if (name == null) {
            name = queueName == null ? VWResource.s_noneParticipant : "[" + queueName + "]";
        }
        return name;
    }

    protected JLabel getOperationName(VWTrkParticipant participant) {
        String queueName = null;
        String operationName = null;
        JLabel label = null;
        try {
            queueName = participant.getQueueName();
            if (queueName == null) {
                return null;
            }
            if (this.getDataModel().getProcess().getSession().getQueue(queueName).getIsConnectorQueue()) {
                operationName = participant.getOperationName();
            }
        }
        catch (Exception ex) {
            operationName = null;
            VWDebug.logException(ex);
        }
        if (operationName != null) {
            label = new JLabel(operationName, null, 2);
        }
        return label;
    }

    public void removeReferences() {
        this.m_trackerDataModel = null;
        if (this.m_workItems != null) {
            this.m_workItems.removeAllElements();
            this.m_workItems = null;
        }
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
        }
        if (this.m_sorter != null) {
            this.m_sorter.removeReferences();
            this.m_sorter = null;
        }
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }
}

